Ext.data.JsonP.sol_common_as_WfController({"tagname":"class","name":"sol.common.as.WfController","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.as.WfController.js","href":"lib_sol.common.as.WfController.html#sol-common-as-WfController"}],"author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"version":["1.05.000"],"eloas":true,"requires":["sol.common.Config","sol.common.ExceptionUtils","sol.common.ObjectUtils","sol.common.RepoUtils","sol.common.SordUtils","sol.common.StringUtils","sol.common.WfUtils","sol.common.as.Utils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"requiredAsVersion","tagname":"property","owner":"sol.common.as.WfController","id":"property-requiredAsVersion","meta":{"private":true}},{"name":"solutionAsConfigs","tagname":"property","owner":"sol.common.as.WfController","id":"property-solutionAsConfigs","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"checkCondition","tagname":"method","owner":"sol.common.as.WfController","id":"method-checkCondition","meta":{"private":true}},{"name":"determinePassOnNodes","tagname":"method","owner":"sol.common.as.WfController","id":"method-determinePassOnNodes","meta":{"private":true}},{"name":"dispatch","tagname":"method","owner":"sol.common.as.WfController","id":"method-dispatch","meta":{"private":true}},{"name":"doWorkflow","tagname":"method","owner":"sol.common.as.WfController","id":"method-doWorkflow","meta":{}},{"name":"forward","tagname":"method","owner":"sol.common.as.WfController","id":"method-forward","meta":{}},{"name":"getNextNodes","tagname":"method","owner":"sol.common.as.WfController","id":"method-getNextNodes","meta":{"private":true}},{"name":"getNodeConfig","tagname":"method","owner":"sol.common.as.WfController","id":"method-getNodeConfig","meta":{"private":true}},{"name":"handleControllerFunction","tagname":"method","owner":"sol.common.as.WfController","id":"method-handleControllerFunction","meta":{"private":true}},{"name":"handleDirectRule","tagname":"method","owner":"sol.common.as.WfController","id":"method-handleDirectRule","meta":{"private":true}},{"name":"handleException","tagname":"method","owner":"sol.common.as.WfController","id":"method-handleException","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"run","tagname":"method","owner":"sol.common.as.WfController","id":"method-run","meta":{}},{"name":"wait","tagname":"method","owner":"sol.common.as.WfController","id":"method-wait","meta":{}},{"name":"waitUntil","tagname":"method","owner":"sol.common.as.WfController","id":"method-waitUntil","meta":{"private":true}},{"name":"writeWfChanges","tagname":"method","owner":"sol.common.as.WfController","id":"method-writeWfChanges","meta":{"private":true}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.as.WfController","short_doc":"ELOas workflow controller. ...","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.as.WfController</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Config' rel='sol.common.Config' class='docClass'>sol.common.Config</a></div><div class='dependency'><a href='#!/api/sol.common.ExceptionUtils' rel='sol.common.ExceptionUtils' class='docClass'>sol.common.ExceptionUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.StringUtils' rel='sol.common.StringUtils' class='docClass'>sol.common.StringUtils</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.as.Utils' rel='sol.common.as.Utils' class='docClass'>sol.common.as.Utils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController' target='_blank'>lib_sol.common.as.WfController.js</a></div></pre><div class='doc-contents'><p>ELOas workflow controller.</p>\n\n<p>This class handles ELO AS functions. Functions must be a subclass of <a href=\"#!/api/sol.common.as.FunctionBase\" rel=\"sol.common.as.FunctionBase\" class=\"docClass\">sol.common.as.FunctionBase</a>.</p>\n\n<p>ELO AS functions can be used as workflow nodes. Compared to Index Server functions, there's no script that can be called.\nTherefore a direct rule is called by this controller. The required rule must be passed as a param in the workflows node description field.</p>\n\n<h1>Sample node configuration:</h1>\n\n<pre><code>{\n  \"$directRule\": \"sol.common.as.functions.MyFunction\",\n  \"doSth\": \"like this\"\n}\n</code></pre>\n\n<h1>Controller functions</h1>\n\n<p>Instead of a direct rule, the <code>WfController</code> can use a <code>$controllerFunction</code>.\nCurrently only  <a href=\"#!/api/sol.common.as.WfController-method-wait\" rel=\"sol.common.as.WfController-method-wait\" class=\"docClass\">wait</a> is supported.</p>\n\n<h1>Forwarding behavior</h1>\n\n<p>If the controller calls a direct function, the return value of this function will affect the forwarding behavior.</p>\n\n<p>To forward to the next node (if there are more than one that will be the first one) the direct rule has to return</p>\n\n<pre><code>{ passOn: true }\n</code></pre>\n\n<p>To prevent the forwarding the direct rule has to return</p>\n\n<pre><code>{ passOn: false }\n</code></pre>\n\n<p>If all successor nodes should be activated the result has to be</p>\n\n<pre><code>{ passOn: { all: true } }\n</code></pre>\n\n<p>If the forwarding should happen to specific successor nodes this could be defined by the following result</p>\n\n<pre><code>{ passOn: { nodes: [] } }\n</code></pre>\n\n<p>The nodes list has to contain strings. Those could be node translation keys, names or ids.</p>\n\n<p>If the controller uses a <code>$controllerFunction</code> check the specific function for forwarding configuration (e.g. <a href=\"#!/api/sol.common.as.WfController-method-wait\" rel=\"sol.common.as.WfController-method-wait\" class=\"docClass\">wait</a>).</p>\n\n<h1>Delay workflows (since 1.05.000)</h1>\n\n<p>To take some load of the <code>WfController</code> (in systems with a lot of active workflows) those wokflows could be delayed, and therefore the <code>WfController</code> ignores them.</p>\n\n<p>To activate this in general the node has do define a <code>useDelay</code> property and set that to <code>true</code>.</p>\n\n<p>There are several ways do specify the delay:</p>\n\n<ul>\n<li>The controller function <code>wait</code> can define a check intervall (see <a href=\"#!/api/sol.common.as.WfController-method-wait\" rel=\"sol.common.as.WfController-method-wait\" class=\"docClass\">wait</a>)</li>\n<li>The controller function <code>wait</code> can delay until the check date is reached (see <a href=\"#!/api/sol.common.as.WfController-method-wait\" rel=\"sol.common.as.WfController-method-wait\" class=\"docClass\">wait</a>)</li>\n<li>A direct rule can define a return property <code>delayDateIso</code> to delay the next execution until that date</li>\n</ul>\n\n\n<p><strong>Delay the workflow with direct rule result</strong></p>\n\n<p>Node configuration:</p>\n\n<pre><code>{\n  \"$directRule\": \"sol.common.as.functions.MyFunction\",\n  \"useDelay\": true\n}\n</code></pre>\n\n<p>Result of <code>sol.common.as.functions.MyFunction</code>:</p>\n\n<pre><code>{ passOn: false, delayDateIso: \"20181231120000\" }\n</code></pre>\n\n<p>This will delay the next execution until 12 o'clock on December, 31 2018.\nThe delay is just applied if <code>passOn</code> is not <code>true</code> and if the node configuration defines <code>useDelay=true</code>.</p>\n      <p class='version-tag'>Version: <b>1.05.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div><div id='property-requiredAsVersion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.WfController'>sol.common.as.WfController</span><br/><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController-property-requiredAsVersion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.WfController-property-requiredAsVersion' class='name expandable'>requiredAsVersion</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;9.03.006&quot;</code></p></div></div></div><div id='property-solutionAsConfigs' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.WfController'>sol.common.as.WfController</span><br/><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController-property-solutionAsConfigs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.WfController-property-solutionAsConfigs' class='name expandable'>solutionAsConfigs</a> : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>[]</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-checkCondition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.WfController'>sol.common.as.WfController</span><br/><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController-method-checkCondition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.WfController-method-checkCondition' class='name expandable'>checkCondition</a>( <span class='pre'>value, nodeConfig</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : String<div class='sub-desc'><p>Value to check</p>\n</div></li><li><span class='pre'>nodeConfig</span> : Object<div class='sub-desc'><p>Node configuration</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-determinePassOnNodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.WfController'>sol.common.as.WfController</span><br/><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController-method-determinePassOnNodes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.WfController-method-determinePassOnNodes' class='name expandable'>determinePassOnNodes</a>( <span class='pre'>value, nodeConfig</span> ) : String []<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : String<div class='sub-desc'><p>Value to check</p>\n</div></li><li><span class='pre'>nodeConfig</span> : Object<div class='sub-desc'><p>Node configuration</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String []</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-dispatch' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.WfController'>sol.common.as.WfController</span><br/><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController-method-dispatch' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.WfController-method-dispatch' class='name expandable'>dispatch</a>( <span class='pre'>resultObj, nodeConfig</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Handles the workflow forwarding. ...</div><div class='long'><p>Handles the workflow forwarding.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>resultObj</span> : Object<div class='sub-desc'><p>The result of either the controller function or the direct rule</p>\n</div></li><li><span class='pre'>nodeConfig</span> : Object<div class='sub-desc'><p>The configuration of the current node</p>\n</div></li></ul></div></div></div><div id='method-doWorkflow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.WfController'>sol.common.as.WfController</span><br/><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController-method-doWorkflow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.WfController-method-doWorkflow' class='name expandable'>doWorkflow</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Patch for the ELOas standard library function ´doWorkflow´ to include tasks for groups ...</div><div class='long'><p>Patch for the ELOas standard library function ´doWorkflow´ to include tasks for groups</p>\n</div></div></div><div id='method-forward' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.WfController'>sol.common.as.WfController</span><br/><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController-method-forward' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.WfController-method-forward' class='name expandable'>forward</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Forward\n\nImmediately forwards a workflow. ...</div><div class='long'><p>Forward</p>\n\n<p>Immediately forwards a workflow. Best used to transfer service user rights to the following node.</p>\n\n<p>Node configuration example:</p>\n\n<pre><code>{\n  \"$controllerFunction\": \"forward\"\n}\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>result</p>\n</div></li></ul></div></div></div><div id='method-getNextNodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.WfController'>sol.common.as.WfController</span><br/><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController-method-getNextNodes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.WfController-method-getNextNodes' class='name expandable'>getNextNodes</a>( <span class='pre'>[params]</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Determines the follow up nodes. ...</div><div class='long'><p>Determines the follow up nodes.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>nodes</span> : String[] (optional)<div class='sub-desc'><p>If set, it will be used to determine the following node IDs. This array could contain node names, translation keys or IDs.\nIf the parameter is not set, all successor nodes will be returned.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Comma separated list of node IDs</p>\n</div></li></ul></div></div></div><div id='method-getNodeConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.WfController'>sol.common.as.WfController</span><br/><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController-method-getNodeConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.WfController-method-getNodeConfig' class='name expandable'>getNodeConfig</a>( <span class='pre'></span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Get node configuration ...</div><div class='long'><p>Get node configuration</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Node configuration</p>\n</div></li></ul></div></div></div><div id='method-handleControllerFunction' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.WfController'>sol.common.as.WfController</span><br/><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController-method-handleControllerFunction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.WfController-method-handleControllerFunction' class='name expandable'>handleControllerFunction</a>( <span class='pre'>nodeConfig</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Handle execution of controller function ...</div><div class='long'><p>Handle execution of controller function</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>nodeConfig</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-handleDirectRule' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.WfController'>sol.common.as.WfController</span><br/><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController-method-handleDirectRule' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.WfController-method-handleDirectRule' class='name expandable'>handleDirectRule</a>( <span class='pre'>nodeConfig</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Handle execution of direct rules ...</div><div class='long'><p>Handle execution of direct rules</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>nodeConfig</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-handleException' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.WfController'>sol.common.as.WfController</span><br/><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController-method-handleException' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.WfController-method-handleException' class='name expandable'>handleException</a>( <span class='pre'>ex</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Handle an exception ...</div><div class='long'><p>Handle an exception</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ex</span> : String|Exception<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-run' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.WfController'>sol.common.as.WfController</span><br/><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController-method-run' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.WfController-method-run' class='name expandable'>run</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Runs workflow rules ...</div><div class='long'><p>Runs workflow rules</p>\n</div></div></div><div id='method-wait' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.WfController'>sol.common.as.WfController</span><br/><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController-method-wait' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.WfController-method-wait' class='name expandable'>wait</a>( <span class='pre'>nodeConfig</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Wait\n\nNode configuration examples:\n\n{\n  \"$controllerFunction\": \"wait\",\n  \"fieldName\": \"INVOICE_DATACOLLECTION\",\n  \"fi...</div><div class='long'><p>Wait</p>\n\n<p>Node configuration examples:</p>\n\n<pre><code>{\n  \"$controllerFunction\": \"wait\",\n  \"fieldName\": \"INVOICE_DATACOLLECTION\",\n  \"fieldValue\": \"DocXtractor\"\n}\n\n{\n  \"$controllerFunction\": \"wait\",\n  \"fieldName\": \"INVOICE_STATUS\",\n  \"fieldValueStartsWith\": \"7\"\n}\n</code></pre>\n\n<p>Only forwards an entry when the date defined in GRP-field \"FORWARDING_DATE\" is reached.</p>\n\n<pre><code>{\n  \"$controllerFunction\": \"wait\",\n  \"fieldName\": \"FORWARDING_DATE\",\n  \"waitUntil\": true\n}\n</code></pre>\n\n<p>Instead of a boolean value, <code>waitUntil</code> also accepts an integer. This integer is an offset in hours from the date which was\nread from the GRP field. (days start at 00:00)</p>\n\n<p>The default forwarding behavior, in case of more then one successor node, is to forward to the first one.\nTo forward to all successor nodes, an additionall parameter <code>forwardToAll</code> has to be defined</p>\n\n<pre><code>{\n  \"$controllerFunction\": \"wait\",\n  \"fieldName\": \"INVOICE_DATACOLLECTION\",\n  \"fieldValue\": \"DocXtractor\",\n  \"forwardToAll\": true\n}\n</code></pre>\n\n<p>Instead of forwarding to the first or all nodes there could be a configuration to forward to specific nodes depending on a field value.\nThe <code>forwardToNodes</code> parameter has an array with node configurations</p>\n\n<pre><code>{\n  \"$controllerFunction\": \"wait\",\n  \"fieldName\": \"INVOICE_STATUS\",\n  \"forwardToNodes\": [\n    { \"node\": \"Error\", \"fieldValue\": \"DECLINED\" },\n    { \"node\": \"Exported\", \"fieldValueStartsWith\": \"7\" },\n    { \"node\": \"ExportedConditionally\", \"fieldValueStartsWith\": \"8\" }\n  ]\n}\n</code></pre>\n\n<p>This configuration shows the following cases:</p>\n\n<ul>\n<li>value of the field 'INVOICE_STATUS' is 'DECLINED' the workflow gets forwarded to the successor node 'Error' => <code>{ passOn: { nodes: [\"Error\"] } }</code></li>\n<li>value of the field 'INVOICE_STATUS' starts with '7' the workflow gets forwarded to the successor node 'Exported' => <code>{ passOn: { nodes: [\"Exported\"] } }</code></li>\n<li>value of the field 'INVOICE_STATUS' starts with '8' the workflow gets forwarded to the successor node 'ExportedConditionally' => <code>{ passOn: { nodes: [\"ExportedConditionally\"] } }</code></li>\n</ul>\n\n\n<p>The property 'node' could either be the translation key, the name or the id of the successor node.</p>\n\n<p>The <code>wait</code> function supports the delay of workflows. This can be used to take some load of the <code>WfController</code>, if there are a lot of active workflows in the system.\nThere are several ways to delay a workflow.</p>\n\n<p>If <code>waitUntil</code> is used the workflow can be delayed to the specified date.\n<em>Use carefully: if the date field changes to an earlier date, the workflow stays suspended till the former specified date.</em></p>\n\n<pre><code>{\n  \"$controllerFunction\": \"wait\",\n  \"fieldName\": \"FORWARDING_DATE\",\n  \"waitUntil\": true,\n  \"useDelay\": true\n}\n</code></pre>\n\n<p>This will delay the workflow till the date specified in FORWARDING_DATE.</p>\n\n<p><code>useDelay</code> can also be used to specify a new check intervall. If specified, the WfController will check this specific workflow in longer intervalls as usual.\n<em>Use carefully: if you specify a relative short intervall (like e.g. 1 minute) the overhead of delaying the workflow over and over again will be greater then the time the actual check would take.</em></p>\n\n<pre><code>{\n  \"$controllerFunction\": \"wait\",\n  \"fieldName\": \"INVOICE_DATACOLLECTION\",\n  \"fieldValue\": \"DocXtractor\",\n  \"useDelay\": true,\n  \"intervall\": { \"hours\": 1 }\n}\n</code></pre>\n\n<p>This will delay each next check for one hour.\nFor syntax of <code>intervall</code> see <a href=\"https://momentjs.com/docs/#/manipulating/add/\">moment.js/add (object literal)</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>nodeConfig</span> : Object<div class='sub-desc'><p>Node configuration</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>result</p>\n</div></li></ul></div></div></div><div id='method-waitUntil' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.WfController'>sol.common.as.WfController</span><br/><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController-method-waitUntil' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.WfController-method-waitUntil' class='name expandable'>waitUntil</a>( <span class='pre'>value, waitDef</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>waitDef</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-writeWfChanges' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.as.WfController'>sol.common.as.WfController</span><br/><a href='source/lib_sol.common.as.WfController.html#sol-common-as-WfController-method-writeWfChanges' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.as.WfController-method-writeWfChanges' class='name expandable'>writeWfChanges</a>( <span class='pre'>resultObj, nodeConfig</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Writes changes to the workflow. ...</div><div class='long'><p>Writes changes to the workflow. Currently only <code>delayDateIso</code> is supported.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>resultObj</span> : Object<div class='sub-desc'><p>The result of either the controller function or the direct rule</p>\n<ul><li><span class='pre'>delayDateIso</span> : String<div class='sub-desc'><p>The date till wich the workflow should be delayed.</p>\n</div></li></ul></div></li><li><span class='pre'>nodeConfig</span> : Object<div class='sub-desc'><p>The configuration of the current node</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"singleton":true}});